﻿<%@ Page Title="" Language="C#" MasterPageFile="~/OneColumn.master" AutoEventWireup="true"
    CodeBehind="TaskList.aspx.cs" Inherits="GUI.Pages.TaskList" %>

<asp:Content ID="Content4" ContentPlaceHolderID="Content" runat="server">
    <div class="main-form-box">
        <script type="text/javascript">
            function pnlRequestStarted(ajaxPanel, eventArgs) {
                if (eventArgs.EventTarget.indexOf("btnPdf") > 0 ||
                eventArgs.EventTarget.indexOf("btnExcel") > 0 ||
                eventArgs.EventTarget.indexOf("btnWord") > 0) {
                    eventArgs.EnableAjax = false;
                }
            }
        </script>
        <h2>
            <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ListTasks %>" /></h2>
        <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1"
            ClientEvents-OnRequestStart="pnlRequestStarted">
            <div class="form-wrapper">
                <div class="row">
                    <div class="six columns">
                        &nbsp;
                    </div>
                    <div class="eight columns">
                        <div class="buttonBar">
                            <asp:CheckBox ID="chkShowAllData" Text="<%$ Resources:ProjectManagementUI, UI_ExportAllData %>" runat="server" />
                            <asp:Button ID="btnPdf" OnClick="BtnPdfClick" CssClass="button orange" Text="Export PDF"
                                runat="server" />
                            <asp:Button ID="btnExcel" OnClick="BtnExcelClick" CssClass="button orange" Text="Export Excel"
                                runat="server" />
                            <asp:Button ID="btnWord" OnClick="BtnWordClick" CssClass="button orange" Text="Export Word"
                                runat="server" />
                        </div>
                    </div>
                </div>
                <div class="content-wrapper">
                </div>
                <div class="splitt10">
                </div>
                <telerik:RadGrid ID="grdTaskList" OnGridExporting="OnGridExporting" runat="server"
                    PageSize="15" AllowFilteringByColumn="true" OnItemCommand="grdTaskList_OnItemCommand"
                    AllowPaging="true" AllowSorting="true" OnNeedDataSource="grdTaskList_OnNeedDataSource" Skin="Bootstrap">
                    <GroupingSettings CaseSensitive="false" />
                    <PagerStyle Mode="NextPrevAndNumeric" />
                    <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False"
                        AutoGenerateColumns="False" DataKeyNames="Id">
                        <Columns>
                            <telerik:GridBoundColumn UniqueName="NameColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                SortExpression="Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>" DataField="Name" />
                            <telerik:GridBoundColumn UniqueName="IsClosedColumn" AutoPostBackOnFilter="true"
                                CurrentFilterFunction="EqualTo" SortExpression="IsClosedDisplay" ShowFilterIcon="false"
                                HeaderText="<%$ Resources:ProjectManagementUI, Task_Finished %>" DataField="IsClosedDisplay" />
                            <telerik:GridBoundColumn UniqueName="ActivitiyColumn" AutoPostBackOnFilter="true"
                                CurrentFilterFunction="Contains" SortExpression="Activity.Name" ShowFilterIcon="false"
                                HeaderText="<%$ Resources:ProjectManagementUI, Common_Activity %>" DataField="Activity.Name" />
                            <telerik:GridBoundColumn UniqueName="UsersColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                SortExpression="UsersDisplayString" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Task_Assigned %>"
                                DataField="UsersDisplayString" />
                            <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderText=""
                                ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ButtonCssClass="delete" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>"
                                ConfirmDialogType="RadWindow" ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                            <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderText=""
                                ButtonCssClass="edit" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>" />
                        </Columns>
                    </MasterTableView>
                </telerik:RadGrid>
            </div>
        </telerik:RadAjaxPanel>
    </div>
    <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1">
        <div class="updatePanelProgress">
            <asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>
</asp:Content>
